/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.base.reference;

import com.google.common.primitives.Ints;
import org.jf.dexlib2.base.reference.BaseReference;
import org.jf.dexlib2.formatter.DexFormatter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;

public abstract class BaseMethodHandleReference
extends BaseReference
implements MethodHandleReference {
    @Override
    public int hashCode() {
        int hashCode = this.getMethodHandleType();
        hashCode = hashCode * 31 + this.getMemberReference().hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof MethodHandleReference) {
            MethodHandleReference other = (MethodHandleReference)o;
            return this.getMethodHandleType() == other.getMethodHandleType() && this.getMemberReference().equals(other.getMemberReference());
        }
        return false;
    }

    @Override
    public int compareTo(MethodHandleReference o) {
        int res = Ints.compare(this.getMethodHandleType(), o.getMethodHandleType());
        if (res != 0) {
            return res;
        }
        Reference reference = this.getMemberReference();
        if (reference instanceof FieldReference) {
            if (!(o.getMemberReference() instanceof FieldReference)) {
                return -1;
            }
            return ((FieldReference)reference).compareTo((FieldReference)o.getMemberReference());
        }
        if (!(o.getMemberReference() instanceof MethodReference)) {
            return 1;
        }
        return ((MethodReference)reference).compareTo((MethodReference)o.getMemberReference());
    }

    public String toString() {
        return DexFormatter.INSTANCE.getMethodHandle(this);
    }
}

